<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Add_Ballot_Controller extends CI_Controller {

    public function Add_Ballot_View()
    {
        $this->load->model('Add_Zone_Model');

        $zones = $this->Add_Zone_Model->Show_Zones();
        if ($zones) {
            $all_data['data'] = $zones;
            $this->load->view('Add_Ballot_View', $all_data);
        } else {
            echo "Zones not found.";
        }
    }

    public function Add_Ballot_Data()
    {
        $this->load->library('form_validation');

        // Required fields
        $this->form_validation->set_rules('zone', 'Zone', 'required');
        $this->form_validation->set_rules('position', 'Ballot Name', 'required|is_unique[ballot.ballot_name]');
        $this->form_validation->set_rules('date', 'Date of Voting', 'required');
        $this->form_validation->set_rules('candidate_type', 'Candidate Type', 'required');

        $candidate_type = $this->input->post('candidate_type');
        $is_multiple = ($candidate_type === 'multiple') ? 1 : 0;

        // If multiple candidates, validate total and voting numbers
        if ($is_multiple === 1) {
            $this->form_validation->set_rules('total_candidates', 'Total Candidates', 'required|integer|greater_than[0]');
            $this->form_validation->set_rules('voting_candidates', 'Voting Candidates', 'required|integer|greater_than[0]');
        }

        if ($this->form_validation->run()) {
            $zone = $this->input->post('zone');
            $position = $this->input->post('position');
            $date = $this->input->post('date');

            $edit_data = array(
                'zone' => $zone,
                'ballot_name' => $position,
                'date' => $date,
                'candidate_type' => $is_multiple,
                'total_votes' => 0
            );

            if ($is_multiple === 1) {
                $total = (int) $this->input->post('total_candidates');
                $voting = (int) $this->input->post('voting_candidates');

                // Backend logic validation
                if ($total === $voting) {
                    $this->session->set_flashdata('error', 'Total Candidates and Voting Candidates cannot be the same.');
                    redirect(base_url() . 'index.php/Add_Ballot_Controller/Add_Ballot_View');
                    return;
                }

                if ($voting > $total) {
                    $this->session->set_flashdata('error', 'Voting Candidates cannot be more than Total Candidates.');
                    redirect(base_url() . 'index.php/Add_Ballot_Controller/Add_Ballot_View');
                    return;
                }

                $edit_data['total_candidates'] = $total;
                $edit_data['voting_candidates'] = $voting;
            }

            $this->load->model('Add_Ballot_Model');
            if ($this->Add_Ballot_Model->Insert_Ballot_Data($edit_data)) {

                $this->load->model('Show_All_Data_Model');
                $clients = $this->Show_All_Data_Model->Fetch_Client_Data_Zone($zone);

                if ($clients) {
                    $this->load->model('Add_Client_To_Ballots');
                    foreach ($clients as $client) {
                        $this->Add_Client_To_Ballots->Insert_Data([
                            'client_id' => $client->cid,
                            'ballot_name' => $position,
                            'vote' => 0
                        ]);
                    }
                }

                $this->session->set_flashdata('ballot_added', 'Ballot Added Successfully');
                redirect(base_url() . 'index.php/Add_Ballot_Controller/Add_Ballot_View');
            } else {
                $this->session->set_flashdata('error', 'Failed to insert ballot.');
                redirect(base_url() . 'index.php/Add_Ballot_Controller/Add_Ballot_View');
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect(base_url() . 'index.php/Add_Ballot_Controller/Add_Ballot_View');
        }
    }
}
