<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Add_Participant_Controller extends CI_Controller {

    public function AddCandidates()
	{
        $this->load->model('Add_Ballot_Model');
        
        if($this->Add_Ballot_Model->Show_Ballot())
            {   
                $all_data['data']=$this->Add_Ballot_Model->Show_Ballot();

                $this->load->view('Add_Candidates_View',$all_data);    
            }

    }
    
    public function VotingCandidates()
    {
        if(isset($_SESSION['candidate_added'])){
            unset($_SESSION['candidate_added']);
            }

        $this->load->library('form_validation');
        $image_url=" ";
        $up_data=" ";    
        $config['allowed_types'] = 'jpg|png|jpeg';
        $config['upload_path'] = './upload/';

        $this->load->library('upload',$config);
        $this->form_validation->set_rules('ballot', 'text', 'required');
        $this->form_validation->set_rules('candidate_name', 'candidate_name', 'required');
        $this->form_validation->set_rules('place', 'place', 'required');

        if($this->form_validation->run())
        {
            $ballot=$this->input->post('ballot');
            $candidate_name=$this->input->post('candidate_name');
            $place=$this->input->post('place');
            
            if($this->upload->do_upload('candidate_image'))
            {
                $up_data=$this->upload->data();
                $image_url=base_url("upload/".$up_data['raw_name'].$up_data['file_ext']);
            }
            else
            {
                $up_data=$this->upload->data();
                echo "not done"."<br>";
                print_r($this->upload->display_errors());
            }

            $data2=array();
            $data2['participant_name'] = $candidate_name;
            $data2['ballot_name'] = $ballot;
            $data2['img_url'] = $image_url; 
            $data2['place'] = $place;                     
            $data2['vote'] = 0;
            
            $this->load->model('Add_Candidate_Model');

            if($this->Add_Candidate_Model->Insert_Data_Candidates($data2))
            {
                //echo "Inserted";
                 $this->session->set_flashdata('candidate_added','Candidate successfully added');
                 redirect(base_url().'index.php/Add_Participant_Controller/AddCandidates','refresh');
            }
            else
            {
                $this->session->set_flashdata('candidate_added','Candidate not added');
                 redirect(base_url().'index.php/Add_Participant_Controller/AddCandidates','refresh');
                //echo "not Inserted";
            }
        }
        else
        {
            echo "did not work";
        }
    }


}
