<?php
defined('BASEPATH') OR exit('No direct script access allowed');
if(!($this->session->userdata('super_admin'))){
  redirect ('/Login');
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>ACCE ONLINE VOTING</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet"  href="<?php echo base_url()."assets/"; ?>plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <link rel="stylesheet"  href="<?php echo base_url()."assets/"; ?>dist/css/adminlte.min.css">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <style>
    table {
      border-collapse: collapse;
      border-spacing: 0;
      width: 100%;
      border: 1px solid #ddd;
    }
    th, td {
      text-align: left;
      padding: 16px;
    }
    tr:nth-child(even) {
      background-color: lightblue;
    }
  </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">
  <!-- Navbar -->
  <nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
      </li>
    </ul>
    <ul class="navbar-nav ml-auto">
      <li class="nav-item dropdown">
        <a href="<?php echo base_url()."index.php/Login/Log_Out/";?>" class="btn btn-info" style="color:white;font-weight:bolder">LOGOUT</a>
      </li>
    </ul>
  </nav>

  <!-- Sidebar -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <div class="sidebar">
      <div class="user-panel mt-3 pb-3 mb-3 d-flex">
        <div class="image">
          <img src="<?php echo base_url()."assets/"; ?>dist/img/user2-160x160.jpg" class="img-circle elevation-2" alt="User Image">
        </div>
        <div class="info"><a href="#" class="d-block"></a></div>
      </div>
      <nav class="mt-2">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu">
          <li class="nav-item">
            <a href="<?php echo base_url()."index.php/Dashboard_Controller/Count_Func"; ?>" class="nav-link">
              <i class="nav-icon fas fa-tachometer-alt"></i>
              <p>DASHBOARD</p>
            </a>
          </li>
          <li class="nav-item">
            <a href="<?php echo base_url()."index.php/Login/userList"; ?>" class="nav-link">
              <i class="nav-icon fas fa-users"></i>
              <p>USER-LIST</p>
            </a>
          </li>
          <li class="nav-item has-treeview">
            <a href="#" class="nav-link">
              <i class="nav-icon fas fa-cogs"></i>
              <p>MASTER<i class="right fas fa-angle-left"></i></p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item"><a href="<?php echo base_url()."index.php/Add_Client_Contoller/Add_Client_View"; ?>" class="nav-link"><i class="far fa-circle nav-icon"></i><p>ADD USER</p></a></li>
              <li class="nav-item"><a href="<?php echo base_url()."index.php/Import_CSV/"; ?>" class="nav-link"><i class="far fa-circle nav-icon"></i><p>ADD USER-LIST</p></a></li>
              <li class="nav-item"><a href="<?php echo base_url()."index.php/Add_Zone_Controller/Add_Zone_View/"; ?>" class="nav-link"><i class="far fa-circle nav-icon"></i><p>ADD ZONE</p></a></li>
              <li class="nav-item"><a href="<?php echo base_url()."index.php/Add_Ballot_Controller/Add_Ballot_View/"; ?>" class="nav-link"><i class="far fa-circle nav-icon"></i><p>ADD BALLOT</p></a></li>
              <li class="nav-item"><a href="<?php echo base_url()."index.php/Add_Participant_Controller/AddCandidates/"; ?>" class="nav-link"><i class="far fa-circle nav-icon"></i><p>ADD PARTICIPANT</p></a></li>
              <li class="nav-item"><a href="<?php echo base_url()."index.php/Add_SMTP_Controller/Add_Smtp_View/"; ?>" class="nav-link"><i class="far fa-circle nav-icon"></i><p>ADD SMTP</p></a></li>
            </ul>
          </li>
          <li class="nav-item has-treeview">
            <a href="<?php echo base_url()."index.php/Ballot_Controller_Admin/Show_Ballots/"; ?>" class="nav-link">
              <i class="nav-icon fas fa-vote-yea"></i>
              <p>BALLOT<i class="right fas fa-angle-left"></i></p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item"><a href="<?php echo base_url()."index.php/Ballot_Controller_Admin/Show_Ballots/"; ?>" class="nav-link"><i class="far fa-circle nav-icon"></i><p>VIEW BALLOT</p></a></li>
              <li class="nav-item"><a href="<?php echo base_url()."index.php/Voted_List_Controller/vote_list/"; ?>" class="nav-link"><i class="far fa-circle nav-icon"></i><p>VIEW VOTED LIST</p></a></li>
            </ul>
          </li>
          <li class="nav-item">
            <a href="<?php echo base_url()."index.php/Report_Controller/"; ?>" class="nav-link">
              <i class="nav-icon fas fa-chart-pie"></i>
              <p>REPORT</p>
            </a>
          </li>
        </ul>
      </nav>
    </div>
  </aside>

  <!-- Content Wrapper -->
  <div class="content-wrapper">
    <section class="content">
      <div class="container-fluid">
        <?php if(isset($_SESSION['ballot_added'])){ ?>
          <br><div class="alert alert-info"><?php echo $_SESSION['ballot_added']; ?></div>
        <?php } ?>
        <?php if(isset($_SESSION['error'])){ ?>
          <br><div class="alert alert-danger"><?php echo $_SESSION['error']; ?></div>
        <?php } ?>
        <div class="row">
          <div class="col-md-6">
            <div class="card card-primary">
              <div class="card-header"><h3 class="card-title">Add Ballot</h3></div>
              <form role="form" action="<?php echo base_url();?>index.php/Add_Ballot_Controller/Add_Ballot_Data" method="post">
                <div class="card-body">
                  <div class="form-group">
                    <label>Ballet Name</label>
                    <input type="text" class="form-control" name="position" placeholder="Title Name">
                  </div>
                  <div class="form-group">
                    <label>Select Zone</label>
                    <select name="zone" class="custom-select">
                      <?php foreach($data as $row) { ?>
                        <option value="<?php echo $row->zone; ?>"><?php echo $row->zone; ?></option>
                      <?php } ?>
                    </select>
                  </div>

                  <!-- Candidate Type -->
                  <div class="form-group">
                    <label>Candidate Type</label><br>
                    <div class="form-check form-check-inline">
                      <input class="form-check-input" type="radio" name="candidate_type" id="single" value="single" checked>
                      <label class="form-check-label" for="single">Single Candidate</label>
                    </div>
                    <div class="form-check form-check-inline">
                      <input class="form-check-input" type="radio" name="candidate_type" id="multiple" value="multiple">
                      <label class="form-check-label" for="multiple">Multiple Candidates</label>
                    </div>
                  </div>

                  <!-- Dynamic Fields -->
                  <div id="multipleCandidateFields" style="display:none;">
                    <div class="form-group">
                      <label for="total_candidates">Total Candidates</label>
                      <input type="number" class="form-control" id="total_candidates" name="total_candidates" placeholder="Enter total candidates">
                    </div>
                    <div class="form-group">
                      <label for="voting_candidates">Voting Candidates</label>
                      <input type="number" class="form-control" id="voting_candidates" name="voting_candidates" placeholder="Enter allowed voting candidates">
                    </div>
                  </div>

                  <div class="form-group">
                    <label>Date of Voting</label>
                    <input type="date" class="form-control" name="date">
                  </div>
                </div>
                <div class="card-footer">
                  <button type="submit" class="btn btn-primary">Submit</button>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>

  <footer class="main-footer">
    <div class="float-right d-none d-sm-block"><b>Version</b> 3.0.5</div>
    <strong>&copy; 2014-2019 <a href="http://adminlte.io">BEDRE WEB SOLUTIONS</a>.</strong> All rights reserved.
  </footer>
</div>

<!-- JS Scripts -->
<script src="<?php echo base_url()."assets/"; ?>plugins/jquery/jquery.min.js"></script>
<script src="<?php echo base_url()."assets/"; ?>plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="<?php echo base_url()."assets/"; ?>dist/js/adminlte.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.js"></script>

<!-- Custom JS -->
<script>
$(document).ready(function() {
  $('input[name="candidate_type"]').change(function() {
    if ($('#multiple').is(':checked')) {
      $('#multipleCandidateFields').slideDown();
    } else {
      $('#multipleCandidateFields').slideUp();
      $('#total_candidates').val('');
      $('#voting_candidates').val('');
    }
  });

  $('form').submit(function(e) {
    if ($('#multiple').is(':checked')) {
      var total = parseInt($('#total_candidates').val());
      var voting = parseInt($('#voting_candidates').val());

      if (isNaN(total) || isNaN(voting)) {
        alert("Please enter both Total and Voting Candidates.");
        return false;
      }

      if (total === voting) {
        alert("Total Candidates and Voting Candidates cannot be the same.");
        return false;
      }

      if (voting > total) {
        alert("Voting Candidates cannot be more than Total Candidates.");
        return false;
      }
    }
  });
});
</script>
</body>
</html>
