<?php
defined('BASEPATH') OR exit('No direct script access allowed');

if (!$this->session->userdata('client')) {
    redirect('/Login');
}

$datas = $this->session->userdata('client');
$datas = str_replace(' ', '%20', trim($datas));
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>ACCE Online Voting System</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Favicon -->
  <link rel="icon" href="<?php echo base_url("assets/dist/img/acce-logo.png"); ?>" type="image/png">
  
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo base_url("assets/plugins/fontawesome-free/css/all.min.css"); ?>">
  
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  
  <!-- AdminLTE -->
  <link rel="stylesheet" href="<?php echo base_url("assets/dist/css/adminlte.min.css"); ?>">
  
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  
  <!-- Animate.css -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
  
  <!-- Custom CSS -->
  <style>
    :root {
      --primary-color: #3498db;
      --secondary-color: #2c3e50;
      --accent-color: #e74c3c;
      --light-color: #ecf0f1;
      --dark-color: #2c3e50;
      --success-color: #2ecc71;
    }
    
    body {
      font-family: 'Poppins', sans-serif;
      background-color: #f5f7fa;
    }
    
    .main-header {
      background: var(--secondary-color) !important;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }
    
    .main-sidebar {
      background: var(--dark-color) !important;
    }
    
    .nav-link {
      transition: all 0.3s ease;
    }
    
    .nav-link:hover {
      background-color: rgba(255,255,255,0.1);
      transform: translateX(5px);
    }
    
    .content-header {
      background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%) !important;
      padding: 20px 0 !important;
      border-radius: 0 0 10px 10px;
      margin-bottom: 30px;
      box-shadow: 0 4px 20px rgba(0,0,0,0.1);
    }
    
    .widget-user-header {
      height: 120px;
      border-radius: 10px 10px 0 0 !important;
    }
    
    .widget-user-image {
      top: 80px !important;
    }
    
    .widget-user-image img {
      border: 5px solid white;
      box-shadow: 0 5px 15px rgba(0,0,0,0.2);
      transition: all 0.3s ease;
    }
    
    .widget-user-image img:hover {
      transform: scale(1.05);
      box-shadow: 0 8px 25px rgba(0,0,0,0.3);
    }
    
    .card {
      border: none;
      border-radius: 10px;
      box-shadow: 0 5px 15px rgba(0,0,0,0.05);
      transition: all 0.3s ease;
      margin-bottom: 25px;
      overflow: hidden;
    }
    
    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    }
    
    .card-footer {
      background: white !important;
      border-top: none !important;
      padding: 20px;
    }
    
    .btn-vote {
      background: var(--success-color);
      border: none;
      padding: 12px 30px;
      font-weight: 600;
      letter-spacing: 1px;
      transition: all 0.3s ease;
      box-shadow: 0 4px 15px rgba(46, 204, 113, 0.3);
    }
    
    .btn-vote:hover {
      background: #27ae60;
      transform: translateY(-2px);
      box-shadow: 0 6px 20px rgba(46, 204, 113, 0.4);
    }
    
    .btn-logout {
      background: var(--accent-color);
      border: none;
      transition: all 0.3s ease;
    }
    
    .btn-logout:hover {
      background: #c0392b;
    }
    
    .marquee-container {
      background: rgba(0,0,0,0.05);
      padding: 10px;
      border-radius: 5px;
      margin-top: 30px;
    }
    
    .marquee-text {
      color: var(--secondary-color);
      font-weight: 500;
    }
    
    .ballot-name {
      display: inline-block;
      background: rgba(255,255,255,0.2);
      padding: 5px 15px;
      border-radius: 20px;
      margin-left: 10px;
    }
    
    .user-panel img {
      box-shadow: 0 3px 10px rgba(0,0,0,0.2);
    }
    
    /* Custom checkbox */
    .custom-checkbox {
      position: relative;
      padding-left: 30px;
      cursor: pointer;
      display: inline-block;
      margin-top: 10px;
    }
    
    .custom-checkbox input {
      position: absolute;
      opacity: 0;
      cursor: pointer;
      height: 0;
      width: 0;
    }
    
    .checkmark {
      position: absolute;
      top: 0;
      left: 0;
      height: 20px;
      width: 20px;
      background-color: #eee;
      border-radius: 4px;
      transition: all 0.3s ease;
    }
    
    .custom-checkbox:hover .checkmark {
      background-color: #ccc;
    }
    
    .custom-checkbox input:checked ~ .checkmark {
      background-color: var(--success-color);
    }
    
    .checkmark:after {
      content: "";
      position: absolute;
      display: none;
    }
    
    .custom-checkbox input:checked ~ .checkmark:after {
      display: block;
    }
    
    .custom-checkbox .checkmark:after {
      left: 7px;
      top: 3px;
      width: 5px;
      height: 10px;
      border: solid white;
      border-width: 0 2px 2px 0;
      transform: rotate(45deg);
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
      .content-header h3 {
        font-size: 1.5rem;
        padding-left: 15px !important;
        text-align: center;
      }
      
      .ballot-name {
        display: block;
        margin: 10px auto 0;
        width: fit-content;
      }
      
      .widget-user-header {
        height: 100px;
      }
      
      .widget-user-image {
        top: 70px !important;
      }
    }
    
    /* Animation classes */
    .fade-in {
      animation: fadeIn 0.5s ease-in;
    }
    
    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(20px); }
      to { opacity: 1; transform: translateY(0); }
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">
  <!-- Navbar -->
  <nav class="main-header navbar navbar-expand navbar-dark">
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
      </li>
      <li class="nav-item d-none d-sm-inline-block">
        <a href="<?php echo base_url("index.php/Login/show_data/{$datas}"); ?>" class="nav-link">Dashboard</a>
      </li>
    </ul>
    <ul class="navbar-nav ml-auto">
      <li class="nav-item">
        <span class="nav-link text-white">
          <i class="fas fa-user-circle mr-1"></i> <?php echo $this->session->userdata('client'); ?>
        </span>
      </li>
      <li class="nav-item">
        <a href="<?php echo base_url('index.php/Login/Log_Out'); ?>" class="btn btn-logout btn-sm">
          <i class="fas fa-sign-out-alt mr-1"></i> LOGOUT
        </a>
      </li>
    </ul>
  </nav>

  <!-- Sidebar -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <div class="sidebar">
      <div class="user-panel mt-3 pb-3 mb-3 d-flex">
        <div class="image">
          <img src="<?php echo base_url("assets/dist/img/user2-160x160.jpg"); ?>" class="img-circle elevation-2" alt="User Image">
        </div>
        <div class="info">
          <a href="#" class="d-block"><?php echo $this->session->userdata('client'); ?></a>
          <small class="text-muted">Voter</small>
        </div>
      </div>
      <nav class="mt-2">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu">
          <li class="nav-item">
            <a href="<?php echo base_url("index.php/Login/show_data/{$datas}"); ?>" class="nav-link">
              <i class="nav-icon fas fa-user"></i>
              <p>My Profile</p>
            </a>
          </li>
          <li class="nav-item">
            <a href="<?php echo base_url("index.php/Show_Voting_Data_Client/VotingTitlesDataClient/{$datas}"); ?>" class="nav-link active">
              <i class="nav-icon fas fa-vote-yea"></i>
              <p>Voting Ballot</p>
            </a>
          </li>
          <li class="nav-item">
            <a href="#" class="nav-link">
              <i class="nav-icon fas fa-info-circle"></i>
              <p>Voting Guidelines</p>
            </a>
          </li>
        </ul>
      </nav>
    </div>
  </aside>

  <!-- Content -->
  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-12">
            <?php if (isset($data)) { ?>
              <h3 class="animate__animated animate__fadeIn">
                Welcome to Online Voting 
                <span class="ballot-name animate__animated animate__pulse animate__infinite"><?php echo $data[0]->ballot_name; ?></span>
              </h3>
            <?php } ?>
          </div>
        </div>
      </div>
    </section>

    <section class="content">
      <div class="container-fluid">
        <?php if($this->session->flashdata('success')): ?>
          <div class="alert alert-success alert-dismissible fade show text-center">
            <i class="icon fas fa-check-circle"></i> <?php echo $this->session->flashdata('success'); ?>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
        <?php endif; ?>
        
        <?php if($this->session->flashdata('error')): ?>
          <div class="alert alert-danger alert-dismissible fade show text-center">
            <i class="icon fas fa-exclamation-triangle"></i> <?php echo $this->session->flashdata('error'); ?>
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
        <?php endif; ?>

        <form method="POST" action="<?php echo base_url("index.php/Update_Voting/multiple_vote_update"); ?>">
          <input type="hidden" name="ballot_name" value="<?php echo isset($data[0]) ? $data[0]->ballot_name : ''; ?>">
          
          <div class="row mt-4 fade-in">
            <?php if (isset($data)): ?>
              <?php foreach($data as $row): ?>
                <div class="col-lg-4 col-md-6">
                  <div class="card card-widget widget-user animate__animated animate__zoomIn">
                    <div class="widget-user-header" style="background: linear-gradient(135deg, <?php echo sprintf('#%06X', mt_rand(0, 0xFFFFFF)); ?> 0%, <?php echo sprintf('#%06X', mt_rand(0, 0xFFFFFF)); ?> 100%)">
                      <h3 class="widget-user-username"><?php echo $row->participant_name ?></h3>
                      <h5 class="widget-user-desc">Candidate</h5>
                    </div>
                    <div class="widget-user-image">
                      <img class="img-circle" src="<?php echo $row->img_url; ?>" alt="Candidate Avatar">
                    </div>
                    <div class="card-footer">
                      <div class="row">
                        <div class="col-sm-12 text-center">
                          <div class="description-block">
                            <i class="fas fa-map-marker-alt"></i>
                            <span class="description-text"><?php echo $row->place ?></span>
                          </div>
                        </div>
                      </div>
                      <div class="row mt-2">
                        <div class="col-12 text-center">
                          <label class="custom-checkbox">
                            Select to vote
                            <input type="checkbox" name="participant_name[]" value="<?php echo $row->participant_name; ?>">
                            <span class="checkmark"></span>
                          </label>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              <?php endforeach; ?>
            <?php else: ?>
              <div class="col-12">
                <div class="card">
                  <div class="card-body text-center py-5">
                    <i class="fas fa-exclamation-circle fa-3x text-muted mb-3"></i>
                    <h3 class="text-muted">No Candidates Found</h3>
                    <p class="text-muted">There are currently no candidates registered for this ballot.</p>
                  </div>
                </div>
              </div>
            <?php endif; ?>
          </div>

          <?php if (isset($data)): ?>
          <div class="row mt-4">
            <div class="col-md-12 text-center">
              <button type="submit" class="btn btn-vote btn-lg" onclick="return confirm('Are you sure you want to submit your vote? This action cannot be undone.');">
                <i class="fas fa-paper-plane mr-2"></i> SUBMIT VOTE
              </button>
            </div>
          </div>
          <?php endif; ?>
        </form>

        <div class="marquee-container mt-5">
        <marquee behavior="scroll" direction="left">
            <?php echo "Your IP is being tracked: " . $_SERVER['REMOTE_ADDR']; ?>
          </marquee>
        </div>
      </div>
    </section>
  </div>

  <footer class="main-footer">
    <div class="float-right d-none d-sm-block">
      <b>Version</b> 3.1.0
    </div>
    <strong>Copyright &copy; <?php echo date("Y"); ?> <a href="#">ACCE Voting System</a>.</strong> All rights reserved.
  </footer>
</div>

<!-- Scripts -->
<script src="<?php echo base_url("assets/plugins/jquery/jquery.min.js"); ?>"></script>
<script src="<?php echo base_url("assets/plugins/bootstrap/js/bootstrap.bundle.min.js"); ?>"></script>
<script src="<?php echo base_url("assets/dist/js/adminlte.min.js"); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>

<script>
  // Add animation to cards on hover
  $(document).ready(function() {
    $('.card').hover(
      function() {
        $(this).addClass('animate__animated animate__pulse');
      },
      function() {
        $(this).removeClass('animate__animated animate__pulse');
      }
    );
    
    // Show loading animation when submitting vote
    $('form').submit(function() {
      $('.btn-vote').html('<i class="fas fa-spinner fa-spin mr-2"></i> Processing...');
      $('.btn-vote').prop('disabled', true);
    });
  });
</script>
</body>
</html>